#ifndef INTR_H
#define INTR_H

#define IRQ_VBLANK			BIT00
#define IRQ_HBLANK			BIT01
#define IRQ_VCOUNT			BIT02
#define IRQ_TM0				BIT03
#define IRQ_TM1				BIT04
#define IRQ_TM2				BIT05
#define IRQ_TM3				BIT06
#define IRQ_COMMS			BIT07
#define IRQ_DMA0			BIT08
#define IRQ_DMA1			BIT09
#define IRQ_DMA2			BIT10
#define IRQ_DMA3			BIT11
#define IRQ_KEY				BIT12
#define IRQ_CART			BIT13

#define SetVBlankIntr(F)	IntrTable[0] = (IntFn)(F); REG_IE |= IRQ_VBLANK;	REG_DISPSTAT |= BIT03;
#define SetHBlankIntr(F)	IntrTable[1] = (IntFn)(F); REG_IE |= IRQ_HBLANK;	REG_DISPSTAT |= BIT04;
#define SetVCountIntr(F, T)	IntrTable[2] = (IntFn)(F); REG_IE |= IRQ_VCOUNT;  REG_DISPSTAT |= BIT05|(REG_DISPSTAT&0xFF)|(T<<8);
#define SetTimer0Intr(F)	IntrTable[3] = (IntFn)(F); REG_IE |= IRQ_TM0;
#define SetTimer1Intr(F)	IntrTable[4] = (IntFn)(F); REG_IE |= IRQ_TM1;
#define SetTimer2Intr(F)	IntrTable[5] = (IntFn)(F); REG_IE |= IRQ_TM2;
#define SetTimer3Intr(F)	IntrTable[6] = (IntFn)(F); REG_IE |= IRQ_TM3;
#define SetSerialIntr(F)	IntrTable[7] = (IntFn)(F); REG_IE |= IRQ_COMMS;
#define SetDMA0Intr(F)		IntrTable[8] = (IntFn)(F); REG_IE |= IRQ_DMA0;
#define SetDMA1Intr(F)		IntrTable[9] = (IntFn)(F); REG_IE |= IRQ_DMA1;
#define SetDMA2Intr(F)		IntrTable[10] = (IntFn)(F); REG_IE |= IRQ_DMA2;
#define SetDMA3Intr(F)		IntrTable[11] = (IntFn)(F); REG_IE |= IRQ_DMA3;
#define SetKeyIntr(F)		IntrTable[12] = (IntFn)(F); REG_IE |= IRQ_KEY;
#define SetCartIntr(F)		IntrTable[13] = (IntFn)(F); REG_IE |= IRW_CART;

#define RemoveVBlankIntr()	IntrTable[0] = dummy; REG_IE &= ~IRQ_VBLANK; REG_DISPSTAT &= ~BIT03;
#define RemoveHBlankIntr()	IntrTable[1] = dummy; REG_IE &= ~IRQ_HBLANK; REG_DISPSTAT &= ~BIT04;
#define RemoveVCountIntr()	IntrTable[2] = dummy; REG_IE &= ~IRQ_VCOUNT; REG_DISPSTAT = REG_DISPSTAT&(0xFF-BIT05);
#define RemoveTimer0Intr()	IntrTable[3] = dummy; REG_IE &= ~IRQ_TM0;
#define RemoveTimer1Intr()	IntrTable[4] = dummy; REG_IE &= ~IRQ_TM1;
#define RemoveTimer2Intr()	IntrTable[5] = dummy; REG_IE &= ~IRQ_TM2;
#define RemoveTimer3Intr()	IntrTable[6] = dummy; REG_IE &= ~IRQ_TM3;
#define RemoveSerialIntr()	IntrTable[7] = dummy; REG_IE &= ~IRQ_COMMS;
#define RemoveDMA0Intr()	IntrTable[8] = dummy; REG_IE &= ~IRQ_DMA0;
#define RemoveDMA1Intr()	IntrTable[9] = dummy; REG_IE &= ~IRQ_DMA1;
#define RemoveDAM2Intr()	IntrTable[10] = dummy; REG_IE &= ~IRQ_DMA2;
#define RemoveDAM3Intr()	IntrTable[11] = dummy; REG_IE &= ~IRQ_DMA3;
#define RemoveKeyIntr()		IntrTable[12] = dummy; REG_IE &= ~IRQ_KEY;
#define RemoveCartIntr()	IntrTable[13] = dummy; REG_IE &= ~IRQ_CART;

#define INT_VECTOR	*(IntFn *)(0x03007ffc)		// BIOS Interrupt vector

#define IntrVBlankWait()	SystemCall(5)

typedef void ( * IntFn)(void);

IntFn IntrTable[14];

void dummy(void);

void IntrMain();
void InitIntr(void);


#endif

